/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.builder;

import com.aptana.editor.php.internal.builder.IPHPLibrary;
import com.aptana.editor.php.internal.builder.LibraryManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UserLibrary
implements IPHPLibrary {
    private String name;
    private List<String> directories;

    public UserLibrary(String serializedLibrary) {
        String[] split = serializedLibrary.split(File.pathSeparator);
        this.name = split[0].trim();
        this.directories = new ArrayList<String>();
        int a = 1;
        while (a < split.length) {
            this.directories.add(split[a].trim());
            ++a;
        }
    }

    public UserLibrary(String text, String[] dirs) {
        this.name = text;
        this.directories = new ArrayList<String>(Arrays.asList(dirs));
    }

    @Override
    public List<String> getDirectories() {
        return new ArrayList<String>(this.directories);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append(this.name);
        bld.append(File.pathSeparator);
        for (String s : this.directories) {
            bld.append(s);
            bld.append(File.pathSeparator);
        }
        bld.deleteCharAt(bld.length() - 1);
        return bld.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserLibrary other = (UserLibrary)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public boolean isTurnedOn() {
        return LibraryManager.getInstance().isTurnedOn(this);
    }
}

